/* $Id: minimum.c,v 1.5 1998/07/20 23:37:09 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

/***************************************************************************

This is a small C code program that gets one block of data from channel 1.

This program is can be used to test your compilation and linking procedures.

If you have never compiled and linked C code on the PC you will need more
information than is presented here.

Be sure to set the include path to the location of hpe1432.h,
 visa.h, vpptype.h....   The default location is \Vxipnp\WinXX\Include.

The linker needs to be told where to find hpe1432_32.lib.  The default
is \Vxipnp\WinXX\Lib\Msc.

Be sure that \Vxipnp\WinXX\Bin is in your path. 


***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "hpe1432.h"

#define BLOCK_SIZE 16

void main()
{
ViSession	session;
ViInt32		channels[10];
ViInt32		gid;
ViReal64	data[BLOCK_SIZE];
char		st[100];
ViInt32		actualCount;
ViInt32		i;
ViStatus	vierr;

    /* initialize instrument  This code ASSUMES hpe1432 at address 8 */
    vierr=hpe1432_init("VXI0::8::INSTR",0,1,&session);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);	    
        exit(0);
    }

    /* make an array of input channel numbers (only one in this simple demo) */
    channels[0]=1;

    vierr=hpe1432_createChannelGroup(session,1,channels,&gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* set the fifo blocksize */
    vierr=hpe1432_setBlocksize(session,gid,BLOCK_SIZE);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* get some data coming */
    vierr=hpe1432_initMeasure(session,gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* wait for the data and then read it */
    vierr=hpe1432_readFloat64Data(session,gid,
                                  HPE1432_TIME_DATA,
                                  data,
                                  BLOCK_SIZE,
                                  &actualCount,
                                  HPE1432_WAIT_FLAG);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* print the data */
    for(i=0;i<5;i++)
		printf("%lf\n",data[i]);


    
}





